
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:09:38 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_RollBack.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/*lint --e{564} */
/*lint --e{774} */
/************* Include Files ***********************************/
#include "SST_TST.h"
#if TST_USE_ROLL_BACK_MODULE
/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
/************* Private function prototype **********************/
/************************ Public Functions *********************/
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_RollBack         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the capability of transaction rollback while inserting, deleting and modifying objects
 *  
 * Algorithm:       
 *    1.  Create a new session by calling: SST_SessionCreate.
 *    2.  Open a transaction by calling: SST_TransactionStart.
 *    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    4.  Close the transaction by calling: SST_TransactionEnd.
 *    5.  Open the password authenticator by calling: SST_AuthenticationOpen.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Insert a new data objects 1~4 (type: simple data) by calling: SST_InsertData.
 *    8.    Create a new iterator by calling: SST_TypeIteratorBegin. With the simple data handle 
 *    9.    Get all handles and verify all are correct and exist
 *          a. Verify all handles returned are correct
 *          b. Verify numbers of handles returned
 *          c. Check that all handles returned are valid
 *    10.   Delete Iterator by calling: SST_TypeIteratorTerminate
 *    11.   Close the transaction by calling: SST_TransactionEnd.
 *    12.   Open a transaction by calling: SST_TransactionStart. 
 *    13.   Insert a new Data objects 1~2 as additional data by calling: SST_InsertData.
 *    14.   Roll back the modification of the data by calling: SST_TransactionRollback 
 *    15.   Create a new iterator by calling: SST_TypeIteratorBegin. With the simple data handle 
 *    16.   Get all handles and verify all are correct and exist
 *          a. Verify all handles returned are correct
 *          b. Verify numbers of handles returned
 *          c. Check that all handles returned are valid
 *    17.   Open a transaction by calling: SST_TransactionStart.
 *    18.   Get Data to temp buffer before modification
 *    19.   Modify the data from selected location by calling: SST_DataModify
 *    20.   Roll back the modification of the data by calling: SST_TransactionRollback 
 *    21.   Retrieve the data and verify it was not modified
 *    22.   Open a transaction by calling: SST_TransactionStart
 *    23.   Delete all the data objects (one by one) by calling: SST_DataDelete. 
 *    24.   Roll back the modification of the data by calling: SST_TransactionRollback 
 *    25.   Create a new iterator by calling: SST_TypeIteratorBegin. With the simple data handle 
 *    26.   Get all handles and verify all are correct and exist
 *          a. Verify all handles returned are correct
 *          b. Verify numbers of handles returned
 *          c. Check that all handles returned are valid
 *    27.   Open a transaction by calling: SST_TransactionStart
 *    28.   Delete the iterator by calling: SST_TypeIteratorTerminate.
 *    29.   Delete all the data objects (one by one) by calling: SST_DataDelete.
 *    30.   Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    31.   Close the transaction by calling: SST_TransactionEnd.
 *    32.   Delete the session by calling: SST_SessionDelete.
 *
 * Comment:
 *    This test uses the Iterator test data and structures
 *
 *******************************************************************************/    
DxError_t SST_TST_ATP_RollBack ( void )
{
     /********* TST Variables Definitions ************/
    int                 TST_index,TST_HandleType,TST_NumberOfHandleMatch;
    char                TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_RollBack";
    SSTSessionId_t      TST_SessionId; 
    SSTTxnId_t          TST_TransactionId;
    SSTHandle_t         TST_AuthHandle;
    SSTHandle_t         TST_DataHandle1,TST_DataHandle2,TST_DataHandle3,TST_DataHandle4;
    SSTHandle_t         TST_DataHandleTmp1,TST_DataHandleTmp2;
    SSTDataType_t       TST_SimpleData = TST_DATA_OBJECT;
    DxUint32_t          TST_TempHandlesToRead,TST_HandlesLeftToRead,TST_TempDataSize;
    SSTIteratorCookie_t TST_IteratorHandle;
    SSTHandle_t         TST_ReturenedHandleBuff[TST_MAX_NUMBERS_OF_HANDLES_2READ];
  SSTHandle_t         TST_AuthDefaultHandle;
    DxUint8_t           TST_TempOutputDataBefore[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint8_t           TST_TempOutputDataAfter[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint8_t           TST_TempWriteBuff[TST_SMALL_BUFFER] = {0} ;
  DxError_t        TST_Status = DX_FAILURE;
    /********* TST Variables initialization *********/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ** SST_TST_ATP_RollBack Tests ********************* \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

    for (TST_HandleType = TST_INTERNAL_HANDLE ; TST_HandleType < TST_HANDLES_TYPES ; TST_HandleType++)
    {
        for (TST_index =0 ; TST_index < TST_NumberOf_IteratorTests ; TST_index++) /*To run on all test vectors*/
        {
            if (TST_HandleType == TST_INTERNAL_HANDLE)
            {   
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
                TST_DataHandle1.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_DataHandle2.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_DataHandle3.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_DataHandle4.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_DataHandleTmp1.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_DataHandleTmp2.objId = SST_HANDLE_RANDOM_GENERATE;
            }
            else
            {
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using external handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId = TST_TEST_DEFINED_HENDLE;
                TST_DataHandle1.objId = TST_TEST_DEFINED_HENDLE_1;
                TST_DataHandle2.objId = TST_TEST_DEFINED_HENDLE_2;
                TST_DataHandle3.objId = TST_TEST_DEFINED_HENDLE_3;
                TST_DataHandle4.objId = TST_TEST_DEFINED_HENDLE_4;
                TST_DataHandleTmp1.objId = TST_TEST_DEFINED_HENDLE_5;
                TST_DataHandleTmp2.objId = TST_TEST_DEFINED_HENDLE_6;
            }

            ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_ATP_IteratorTestData[TST_index].TST_Name,"\n"));

            /* Create a session for operations */
            /*---------------------------------*/
            TST_Status = SST_SessionCreate(&TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Create a new password authenticator */
            /*-------------------------------------*/
            TST_AuthDefaultHandle.objDigest = 0;
      TST_AuthDefaultHandle.objId = SST_CLOSE_AUTH_HANDLE;
            TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                        TST_SessionId,
                                                        TST_ATP_IteratorTestData[TST_index].TST_Password,
                                                        TST_ATP_IteratorTestData[TST_index].TST_PasswordSizeInBytes,
                                                        TST_ATP_IteratorTestData[TST_index].TST_MaxNumOfTrials,
                                                        TST_AuthDefaultHandle,
                                                        &TST_AuthHandle,
                                                        TST_Workspace,
                                                        TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                                                  TST_MasterTestName);

      /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open the password authentication */
            /*----------------------------------*/
            TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                               TST_AuthHandle,
                                               TST_ATP_IteratorTestData[TST_index].TST_Password,
                                               TST_ATP_IteratorTestData[TST_index].TST_PasswordSizeInBytes,
                                               TST_NO_CHALLENGE,
                                               TST_Workspace,
                                               TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Insert a new Data objects 1~4 */
            /*-------------------------------*/
            /* Data1*/
            TST_Status = SST_DataInsert(TST_TransactionId,
                                       TST_SessionId, 
                                       TST_AuthHandle,       
                                       TST_ATP_IteratorTestData[TST_index].TST_Data,
                                       TST_ATP_IteratorTestData[TST_index].TST_DataSize,
                                       DX_TRUE,
                                       TST_SimpleData,                
                                       &TST_DataHandle1,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert1",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            /*Data2*/
            TST_Status = SST_DataInsert(TST_TransactionId,
                                       TST_SessionId, 
                                       TST_AuthHandle,       
                                       TST_ATP_IteratorTestData[TST_index].TST_Data,
                                       TST_ATP_IteratorTestData[TST_index].TST_DataSize,
                                       DX_TRUE,
                                       TST_SimpleData,                
                                       &TST_DataHandle2,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert2",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            /*Data3*/
            TST_Status = SST_DataInsert(TST_TransactionId,
                                       TST_SessionId, 
                                       TST_AuthHandle,       
                                       TST_ATP_IteratorTestData[TST_index].TST_Data,
                                       TST_ATP_IteratorTestData[TST_index].TST_DataSize,
                                       DX_TRUE,
                                       TST_SimpleData,                
                                       &TST_DataHandle3,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert3",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            /*data4*/
            TST_Status = SST_DataInsert(TST_TransactionId,
                                       TST_SessionId, 
                                       TST_AuthHandle,       
                                       TST_ATP_IteratorTestData[TST_index].TST_Data,
                                       TST_ATP_IteratorTestData[TST_index].TST_DataSize,
                                       DX_TRUE,
                                       TST_SimpleData,                
                                       &TST_DataHandle4,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert4",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);



            /* Create a new iterator with the simple data handle */
            /*---------------------------------------------------*/
            TST_Status = SST_TypeIteratorBegin(TST_SessionId,
                        TST_SimpleData,
                        &TST_IteratorHandle,
                        TST_Workspace,
                        TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TypeIteratorBegin - simple data handle",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Get all handles and verify all are correct and exist */
            /*------------------------------------------------------*/
            TST_TempHandlesToRead = TST_MAX_NUMBERS_OF_HANDLES_2READ;
            TST_Status = SST_TypeIteratorHandlesGet(TST_SessionId,
                                                  &TST_IteratorHandle,
                                                  &TST_TempHandlesToRead,                                               
                                                  TST_ReturenedHandleBuff,
                          &TST_HandlesLeftToRead,
                          TST_Workspace,
                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TypeIteratorHandlesGet",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Verify all handles returned are correct */
            /*-----------------------------------------*/
            /* Verify numbers of handles returned*/
            TST_Status = TESTFAIL;
            if ((TST_TempHandlesToRead == TST_4_HANDLES)&&
                (TST_HandlesLeftToRead == TST_ZERO))
                    TST_Status = TESTPASS;

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Verify numbers of handles returned",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);



            /* Check that all handles returned are valid */
           TST_NumberOfHandleMatch = TST_ZERO;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle1)))
                TST_NumberOfHandleMatch++;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle2)))
                TST_NumberOfHandleMatch++;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle3)))
                TST_NumberOfHandleMatch++;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle4)))
                TST_NumberOfHandleMatch++;

            if (TST_NumberOfHandleMatch != TST_4_HANDLES)
                TST_Status = TESTFAIL;        

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Check that all handles returned are valid",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete Iterator */
            /*-----------------*/
            TST_Status = SST_TypeIteratorTerminate(TST_SessionId, 
                          &TST_IteratorHandle,
                          TST_Workspace,
                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TypeIteratorTerminate",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


      /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a new transaction for operations */
            /*---------------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Insert a new Data objects 1~2 as additional data */
            /*--------------------------------------------------*/
            /* Data1*/
            TST_Status = SST_DataInsert(TST_TransactionId,
                                       TST_SessionId, 
                                       TST_AuthHandle,       
                                       TST_ATP_IteratorTestData[TST_index].TST_Data,
                                       TST_ATP_IteratorTestData[TST_index].TST_DataSize,
                                       DX_TRUE,
                                       TST_SimpleData,                
                                       &TST_DataHandleTmp1,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            /*Data2*/
            TST_Status = SST_DataInsert(TST_TransactionId,
                                       TST_SessionId, 
                                       TST_AuthHandle,       
                                       TST_ATP_IteratorTestData[TST_index].TST_Data,
                                       TST_ATP_IteratorTestData[TST_index].TST_DataSize,
                                       DX_TRUE,
                                       TST_SimpleData,                
                                       &TST_DataHandleTmp2,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Roll back the insertion on data operation */
            /*-------------------------------------------*/
            TST_Status = SST_TransactionRollback(TST_TransactionId,
                                                TST_Workspace,
                                                TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionRollback",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Create a new iterator with the simple data handle */
            /*---------------------------------------------------*/
            TST_Status = SST_TypeIteratorBegin(TST_SessionId,
                        TST_SimpleData,
                        &TST_IteratorHandle,
                        TST_Workspace,
                        TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TypeIteratorBegin - simple data handle",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Get all handles and verify all are correct and exist */
            /*------------------------------------------------------*/
            TST_TempHandlesToRead = TST_MAX_NUMBERS_OF_HANDLES_2READ;
            TST_Status = SST_TypeIteratorHandlesGet(TST_SessionId,
                                                  &TST_IteratorHandle,
                                                  &TST_TempHandlesToRead,                                               
                                                  TST_ReturenedHandleBuff,
                          &TST_HandlesLeftToRead,
                          TST_Workspace,
                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IteratorAllHandlesGet",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Verify all handles returned are correct */
            /*-----------------------------------------*/
            /* Verify numbers of handles returned*/
            TST_Status = TESTFAIL;
            if ((TST_TempHandlesToRead == TST_4_HANDLES)&&
                (TST_HandlesLeftToRead == TST_ZERO))
                    TST_Status = TESTPASS;

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Verify numbers of handles returned",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);



            /* Check that all handles returned are valid */
           TST_NumberOfHandleMatch = TST_ZERO;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle1)))
                TST_NumberOfHandleMatch++;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle2)))
                TST_NumberOfHandleMatch++;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle3)))
                TST_NumberOfHandleMatch++;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle4)))
                TST_NumberOfHandleMatch++;

            if (TST_NumberOfHandleMatch != TST_4_HANDLES)
                TST_Status = TESTFAIL;        

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Check that all handles returned are valid",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a new transaction for operations */
            /*---------------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Get Data to temp buffer before modification */
            /*---------------------------------------------*/
            TST_TempDataSize = TST_ATP_IteratorTestData[TST_index].TST_DataSize;

            TST_Status = SST_DataRead(TST_SessionId,
                                     TST_DataHandle1,
                                     TST_NO_OFFSET,
                                     TST_TempOutputDataBefore,
                                     &TST_TempDataSize,
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataRead",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Modify the data from selected location */
            /*----------------------------------------*/
            TST_Status = SST_DataModify(TST_TransactionId,
                                       TST_SessionId,                           
                                       TST_DataHandle1,  
                                       TST_TempWriteBuff,
                                       sizeof(TST_TempWriteBuff),
                                       TST_NO_OFFSET,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataModify",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);



            /* Roll back the modification of the data */
            /*----------------------------------------*/
            TST_Status = SST_TransactionRollback(TST_TransactionId,
                                                TST_Workspace,
                                                TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionRollback",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Retrieve the data and verify it was not modified */
            /*--------------------------------------------------*/
            /* Get Data to temp buffer after modification */
            TST_TempDataSize = TST_ATP_IteratorTestData[TST_index].TST_DataSize;

            TST_Status = SST_DataRead(TST_SessionId,
                                     TST_DataHandle1,
                                     TST_NO_OFFSET,
                                     TST_TempOutputDataAfter,
                                     &TST_TempDataSize,
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataRead",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Compare the two data to see data was not modified */
         if(!DX_VOS_MemCmp(TST_TempOutputDataAfter,
                TST_TempOutputDataBefore,
                TST_ATP_IteratorTestData[TST_index].TST_DataSize))
                              TST_Status = TESTPASS; /*Data Buffers are the same*/
                              else
                              TST_Status = TESTFAIL; /*Data Buffers are different*/

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Modified data",
                          TST_ATP_DataOpTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a new transaction for operations */
            /*---------------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


           /* Delete all data objects */
            /*-------------------------*/
            /*DataObject#1*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle1,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - #1",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*DataObject#2*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle2,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - #2",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*DataObject#3*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle3,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - #3",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            /*DataObject#4*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle4,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - #4",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Roll back the deletion of data operation */
            /*------------------------------------------*/
            TST_Status = SST_TransactionRollback(TST_TransactionId,
                                                TST_Workspace,
                                                TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionRollback",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Create a new iterator with the simple data handle */
            /*---------------------------------------------------*/
            TST_Status = SST_TypeIteratorBegin(TST_SessionId,
                        TST_SimpleData,
                        &TST_IteratorHandle,
                        TST_Workspace,
                        TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TypeIteratorBegin - simple data handle",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

           /* Get all handles and verify all are correct and exist */
            /*------------------------------------------------------*/
            TST_TempHandlesToRead = TST_MAX_NUMBERS_OF_HANDLES_2READ;
            TST_Status = SST_TypeIteratorHandlesGet(TST_SessionId,
                                                  &TST_IteratorHandle,
                                                  &TST_TempHandlesToRead,                                               
                                                  TST_ReturenedHandleBuff,
                          &TST_HandlesLeftToRead,
                          TST_Workspace,
                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IteratorAllHandlesGet",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Verify all handles returned are correct */
            /*-----------------------------------------*/
            /* Verify numbers of handles returned*/
            TST_Status = TESTFAIL;
            if ((TST_TempHandlesToRead == TST_4_HANDLES)&&
                (TST_HandlesLeftToRead == TST_ZERO))
                    TST_Status = TESTPASS;

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Verify numbers of handles returned",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);



            /* Check that all handles returned are valid */
           TST_NumberOfHandleMatch = TST_ZERO;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle1)))
                TST_NumberOfHandleMatch++;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle2)))
                TST_NumberOfHandleMatch++;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle3)))
                TST_NumberOfHandleMatch++;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle4)))
                TST_NumberOfHandleMatch++;

            if (TST_NumberOfHandleMatch != TST_4_HANDLES)
                TST_Status = TESTFAIL;        

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Check that all handles returned are valid",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a new transaction for operations */
            /*---------------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);

                
                
            /* Delete Iterator */
            /*-----------------*/
            TST_Status = SST_TypeIteratorTerminate(TST_SessionId, 
                          &TST_IteratorHandle,
                          TST_Workspace,
                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IteratorTerminate",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete all data objects */
            /*-------------------------*/
            /*DataObject#1*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle1,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - #1",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*DataObject#2*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle2,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - #2",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*DataObject#3*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle3,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - #3",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*DataObject#4*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle4,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - #4",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete the authenticator */
            /*--------------------------*/
            TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                                TST_AuthHandle);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete - Master authenticator",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete the session */
            /*--------------------*/
            TST_Status = SST_SessionDelete(TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);

           


        }/*End of TST_index "for loop" */
    }/*End of TST_HandleType "for loop" */
    return TST_Status;

  EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }
}/* End of SST_TST_ATP_BasicDataOp */



/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/

#endif

